/*
  
Macro Scripts File
Created:  24 mai 2003
Version:  3ds MAX 6
Author:   PF Breton

Macro Scripts that fires some Utilities
Purpose: Hooking up some of them from the Main menu

Revision History:
   24 mai 2003, initial implementation for 3ds max 6, pfbreton

   4 dec 2003, adding File Link Manager launcher for 3ds max 6 and  File Link Extension, pfbreton

	17 dec 2003, Pierre-Felix Breton, 
		added File Link Manager Launcher
		added Substitute Manager Launcher

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		
	17 march 2006, Pierre-Felix Breton
		added Publish to DWF command

Macro Scripts that fires some Utilities
Purpose: Hooking up some of them from the Main menu

*/
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

MacroScript Panoramic_Exporter
ButtonText:~PANORAMIC_EXPORTER_BUTTONTEXT~
category:~PANORAMIC_EXPORTER_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~PANORAMIC_EXPORTER_TOOLTIP~ 
(
	try(
            max utility mode
	    utilitypanel.openutility Panorama_Exporter
		) catch()
)


MacroScript Color_Clip_Board
ButtonText:~COLOR_CLIP_BOARD_BUTTONTEXT~
category:~COLOR_CLIP_BOARD_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~COLOR_CLIP_BOARD_TOOLTIP~ 
(
	try (utilitypanel.openutility Color_Clipboard) catch()
)

MacroScript Assign_Vertex_Colors
ButtonText:~ASSIGN_VERTEX_COLORS_BUTTONTEXT~
category:~ASSIGN_VERTEX_COLORS_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~ASSIGN_VERTEX_COLORS_TOOLTIP~ 
(
	try (utilitypanel.openutility Assign_Vertex_Colors) catch()
)


MacroScript Perspective_Match
ButtonText:~PERSPECTIVE_MATCH_BUTTONTEXT~
category:~PERSPECTIVE_MATCH_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~PERSPECTIVE_MATCH_TOOLTIP~ 
(
	try (utilitypanel.openutility Perspective_Match) catch()
)


MacroScript Resource_Collector
ButtonText:~RESOURCE_COLLECTOR_BUTTONTEXT~
category:~RESOURCE_COLLECTOR_CATEGORY~ 
internalCategory:"File" 
Tooltip:~RESOURCE_COLLECTOR_TOOLTIP~ 
(
	try(
		max utility mode
		utilitypanel.openutility Resource_Collector
	) catch()
)

MacroScript Map_Path_Editor
ButtonText:~MAP_PATH_EDITOR_BUTTONTEXT~
category:~MAP_PATH_EDITOR_CATEGORY~ 
internalCategory:"File" 
Tooltip:~MAP_PATH_EDITOR_TOOLTIP~ 
(
	try(
		max utility mode
		utilitypanel.openutility Bitmap_Photometric_Paths
	) catch()
)


MacroScript Channel_Info
ButtonText:~CHANNEL_INFO_BUTTONTEXT~
category:~CHANNEL_INFO_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~CHANNEL_INFO_TOOLTIP~ 
(
	on execute do	(
		try(
			channelInfo.Dialog ()
		) catch()
	)
	on closeDialogs do (
		try (
			channelInfo.closeDialog()
		) catch ()
	)
	on isChecked return (
		try (
			channelInfo.IsChecked ()
		) catch ( false )
	)
)

MacroScript Launch_VMS
ButtonText:~LAUNCH_VMS_BUTTONTEXT~
Category:~LAUNCH_VMS_CATEGORY~ 
internalCategory:"MAX Script" 
Tooltip:~LAUNCH_VMS_TOOLTIP~ 
(
 vms = visualMS.CreateForm()
 vms.Open()
)

MacroScript Publish_To_DWF
ButtonText:~PUBLISH_TO_DWF_BUTTONTEXT~
category:~PUBLISH_TO_DWF_CATEGORY~ 
internalCategory:"File" 
Tooltip:~PUBLISH_TO_DWF_TOOLTIP~ 
(
		--------------------------------
		--Browse for file dialog
		--------------------------------
		 
		local strMyFile= ""
		strMyFile = getSaveFileName caption:~GETSAVEFILENAME_CAPTION~ \ --LOC NOtes: Localize this
							filename:((getdir #export) + "\\" + (getFilenameFile maxfilename) + ".dwf") \
							types:~DESIGN_WEB_FORMAT_TYPES_CAPTION~
		
		-- user canceled?			
		if (strMyFile!= undefined) then  					
		(
			exportFile strMyFile using:DWF_Exporter	
		)--end if
	
)--en publish to DWF

